/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans;

import com.supermartijn642.trashcans.ClientProxy;
import com.supermartijn642.trashcans.TrashCanBlock;
import com.supermartijn642.trashcans.TrashCanTile;
import com.supermartijn642.trashcans.compat.Compatibility;
import com.supermartijn642.trashcans.data.TrashCansAdvancementProvider;
import com.supermartijn642.trashcans.filter.FluidFilterManager;
import com.supermartijn642.trashcans.filter.LiquidTrashCanFilters;
import com.supermartijn642.trashcans.packet.PacketChangeEnergyLimit;
import com.supermartijn642.trashcans.packet.PacketChangeItemFilter;
import com.supermartijn642.trashcans.packet.PacketChangeLiquidFilter;
import com.supermartijn642.trashcans.packet.PacketToggleEnergyLimit;
import com.supermartijn642.trashcans.packet.PacketToggleItemWhitelist;
import com.supermartijn642.trashcans.packet.PacketToggleLiquidWhitelist;
import com.supermartijn642.trashcans.packet.TrashCanPacket;
import com.supermartijn642.trashcans.screen.EnergyTrashCanContainer;
import com.supermartijn642.trashcans.screen.ItemTrashCanContainer;
import com.supermartijn642.trashcans.screen.LiquidTrashCanContainer;
import com.supermartijn642.trashcans.screen.UltimateTrashCanContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@Mod(value="trashcans")
public class TrashCans {
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("trashcans", "main"), () -> "1", "1"::equals, "1"::equals);
    @ObjectHolder(value="trashcans:item_trash_can")
    public static Block item_trash_can;
    @ObjectHolder(value="trashcans:liquid_trash_can")
    public static Block liquid_trash_can;
    @ObjectHolder(value="trashcans:energy_trash_can")
    public static Block energy_trash_can;
    @ObjectHolder(value="trashcans:ultimate_trash_can")
    public static Block ultimate_trash_can;
    @ObjectHolder(value="trashcans:item_trash_can_tile")
    public static BlockEntityType<TrashCanTile> item_trash_can_tile;
    @ObjectHolder(value="trashcans:liquid_trash_can_tile")
    public static BlockEntityType<TrashCanTile> liquid_trash_can_tile;
    @ObjectHolder(value="trashcans:energy_trash_can_tile")
    public static BlockEntityType<TrashCanTile> energy_trash_can_tile;
    @ObjectHolder(value="trashcans:ultimate_trash_can_tile")
    public static BlockEntityType<TrashCanTile> ultimate_trash_can_tile;
    @ObjectHolder(value="trashcans:item_trash_can_container")
    public static MenuType<ItemTrashCanContainer> item_trash_can_container;
    @ObjectHolder(value="trashcans:liquid_trash_can_container")
    public static MenuType<LiquidTrashCanContainer> liquid_trash_can_container;
    @ObjectHolder(value="trashcans:energy_trash_can_container")
    public static MenuType<EnergyTrashCanContainer> energy_trash_can_container;
    @ObjectHolder(value="trashcans:ultimate_trash_can_container")
    public static MenuType<UltimateTrashCanContainer> ultimate_trash_can_container;

    public TrashCans() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
        CHANNEL.registerMessage(0, PacketToggleItemWhitelist.class, TrashCanPacket::encode, PacketToggleItemWhitelist::decode, TrashCanPacket::handle);
        CHANNEL.registerMessage(1, PacketToggleLiquidWhitelist.class, TrashCanPacket::encode, PacketToggleLiquidWhitelist::decode, TrashCanPacket::handle);
        CHANNEL.registerMessage(2, PacketToggleEnergyLimit.class, TrashCanPacket::encode, PacketToggleEnergyLimit::decode, TrashCanPacket::handle);
        CHANNEL.registerMessage(3, PacketChangeEnergyLimit.class, PacketChangeEnergyLimit::encode, PacketChangeEnergyLimit::decode, TrashCanPacket::handle);
        CHANNEL.registerMessage(4, PacketChangeItemFilter.class, PacketChangeItemFilter::encode, PacketChangeItemFilter::decode, TrashCanPacket::handle);
        CHANNEL.registerMessage(5, PacketChangeLiquidFilter.class, PacketChangeLiquidFilter::encode, PacketChangeLiquidFilter::decode, TrashCanPacket::handle);
    }

    public void init(FMLCommonSetupEvent e) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> ClientProxy::registerScreen);
        LiquidTrashCanFilters.register(new FluidFilterManager(), "fluid");
        Compatibility.init();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlockRegistry(RegistryEvent.Register<Block> e) {
            e.getRegistry().register((IForgeRegistryEntry)new TrashCanBlock("item_trash_can", (pos, state) -> new TrashCanTile(item_trash_can_tile, (BlockPos)pos, (BlockState)state, true, false, false), ItemTrashCanContainer::new));
            e.getRegistry().register((IForgeRegistryEntry)new TrashCanBlock("liquid_trash_can", (pos, state) -> new TrashCanTile(liquid_trash_can_tile, (BlockPos)pos, (BlockState)state, false, true, false), LiquidTrashCanContainer::new));
            e.getRegistry().register((IForgeRegistryEntry)new TrashCanBlock("energy_trash_can", (pos, state) -> new TrashCanTile(energy_trash_can_tile, (BlockPos)pos, (BlockState)state, false, false, true), EnergyTrashCanContainer::new));
            e.getRegistry().register((IForgeRegistryEntry)new TrashCanBlock("ultimate_trash_can", (pos, state) -> new TrashCanTile(ultimate_trash_can_tile, (BlockPos)pos, (BlockState)state, true, true, true), UltimateTrashCanContainer::new));
        }

        @SubscribeEvent
        public static void onTileRegistry(RegistryEvent.Register<BlockEntityType<?>> e) {
            e.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)BlockEntityType.Builder.m_155273_((pos, state) -> new TrashCanTile(item_trash_can_tile, pos, state, true, false, false), (Block[])new Block[]{item_trash_can}).m_58966_(null).setRegistryName("item_trash_can_tile")));
            e.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)BlockEntityType.Builder.m_155273_((pos, state) -> new TrashCanTile(liquid_trash_can_tile, pos, state, false, true, false), (Block[])new Block[]{liquid_trash_can}).m_58966_(null).setRegistryName("liquid_trash_can_tile")));
            e.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)BlockEntityType.Builder.m_155273_((pos, state) -> new TrashCanTile(energy_trash_can_tile, pos, state, false, false, true), (Block[])new Block[]{energy_trash_can}).m_58966_(null).setRegistryName("energy_trash_can_tile")));
            e.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)BlockEntityType.Builder.m_155273_((pos, state) -> new TrashCanTile(ultimate_trash_can_tile, pos, state, true, true, true), (Block[])new Block[]{ultimate_trash_can}).m_58966_(null).setRegistryName("ultimate_trash_can_tile")));
        }

        @SubscribeEvent
        public static void onItemRegistry(RegistryEvent.Register<Item> e) {
            e.getRegistry().register((IForgeRegistryEntry)((Item)new BlockItem(item_trash_can, new Item.Properties().m_41491_(CreativeModeTab.f_40754_)).setRegistryName("item_trash_can")));
            e.getRegistry().register((IForgeRegistryEntry)((Item)new BlockItem(liquid_trash_can, new Item.Properties().m_41491_(CreativeModeTab.f_40754_)).setRegistryName("liquid_trash_can")));
            e.getRegistry().register((IForgeRegistryEntry)((Item)new BlockItem(energy_trash_can, new Item.Properties().m_41491_(CreativeModeTab.f_40754_)).setRegistryName("energy_trash_can")));
            e.getRegistry().register((IForgeRegistryEntry)((Item)new BlockItem(ultimate_trash_can, new Item.Properties().m_41491_(CreativeModeTab.f_40754_)).setRegistryName("ultimate_trash_can")));
        }

        @SubscribeEvent
        public static void onContainerRegistry(RegistryEvent.Register<MenuType<?>> e) {
            e.getRegistry().register((IForgeRegistryEntry)((MenuType)IForgeMenuType.create((windowId, inv, data) -> new ItemTrashCanContainer(windowId, inv.f_35978_, data.m_130135_())).setRegistryName("item_trash_can_container")));
            e.getRegistry().register((IForgeRegistryEntry)((MenuType)IForgeMenuType.create((windowId, inv, data) -> new LiquidTrashCanContainer(windowId, inv.f_35978_, data.m_130135_())).setRegistryName("liquid_trash_can_container")));
            e.getRegistry().register((IForgeRegistryEntry)((MenuType)IForgeMenuType.create((windowId, inv, data) -> new EnergyTrashCanContainer(windowId, inv.f_35978_, data.m_130135_())).setRegistryName("energy_trash_can_container")));
            e.getRegistry().register((IForgeRegistryEntry)((MenuType)IForgeMenuType.create((windowId, inv, data) -> new UltimateTrashCanContainer(windowId, inv.f_35978_, data.m_130135_())).setRegistryName("ultimate_trash_can_container")));
        }

        @SubscribeEvent
        public static void onGatherData(GatherDataEvent e) {
            e.getGenerator().m_123914_((DataProvider)new TrashCansAdvancementProvider(e));
        }
    }
}

